<?php
// Include database connection
require_once 'php/db_connect.php';

$username = $password = "";
$username_err = $password_err = $login_err = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
  if (empty(trim($_POST["username"]))) {
    $username_err = "Please enter username.";
  } else {
    $username = trim($_POST["username"]);
  }

  if (empty(trim($_POST["password"]))) {
    $password_err = "Please enter your password.";
  } else {
    $password = trim($_POST["password"]);
  }

  if (empty($username_err) && empty($password_err)) {
    $sql = "
      SELECT id, username, password_hash, is_admin
      FROM users
      WHERE username = ?
    ";
    if ($stmt = $conn->prepare($sql)) {
      $stmt->bind_param("s", $param_username);
      $param_username = $username;
      if ($stmt->execute()) {
        $stmt->store_result();
        if ($stmt->num_rows == 1) {
          $stmt->bind_result($id, $username, $hashed_password, $is_admin);
          if ($stmt->fetch()) {
            if (password_verify($password, $hashed_password)) {
              if (session_status() == PHP_SESSION_NONE) {
                session_start();
              }
              $_SESSION["loggedin"]  = true;
              $_SESSION["user_id"]   = $id;
              $_SESSION["username"]  = $username;
              $_SESSION["is_admin"]  = (bool)$is_admin;
              header("location: mall_selection.php");
              exit;
            } else {
              $login_err = "Invalid username or password.";
            }
          }
        } else {
          $login_err = "Invalid username or password.";
        }
      } else {
        $login_err = "Oops! Something went wrong.";
      }
      $stmt->close();
    }
  }
  $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta
    name="viewport"
    content="width=device-width, initial-scale=1.0"
  >
  <title>Login – Mall Leasing</title>
  <link
    href="https://fonts.googleapis.com/css?family=Roboto:400,500&display=swap"
    rel="stylesheet"
  >
  <style>
    :root {
      --primary: #007bff;
      --primary-hover: #0056b3;
      --bg-page: #f4f7fa;
      --bg-card: #ffffff;
      --text-main: #333333;
      --error-bg: #f8d7da;
      --error-text: #721c24;
    }
    *,
    *::before,
    *::after {
      box-sizing: border-box;
    }
    body {
      margin: 0;
      font-family: 'Roboto', sans-serif;
      font-size: 16px;
      background: var(--bg-page);
      color: var(--text-main);
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      padding: 1rem;
    }
    .login-container {
      background: var(--bg-card);
      padding: 2rem;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      max-width: 400px;
      width: 100%;
    }
    .login-container h2 {
      text-align: center;
      margin-bottom: 1rem;
      font-weight: 500;
    }
    .login-container p.intro {
      text-align: center;
      margin-bottom: 1.5rem;
      color: #555;
    }
    .form-group {
      margin-bottom: 1rem;
    }
    .form-group label {
      display: block;
      margin-bottom: 0.5rem;
      font-weight: 500;
    }
    .form-group input {
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 4px;
      font-size: 1rem;
      transition: border-color 0.2s;
    }
    .form-group input:focus {
      border-color: var(--primary);
      outline: none;
    }
    .error {
      display: block;
      margin-top: 0.25rem;
      color: var(--error-text);
      font-size: 0.875rem;
    }
    .alert-error {
      background: var(--error-bg);
      color: var(--error-text);
      padding: 0.75rem;
      border-radius: 4px;
      margin-bottom: 1rem;
      font-size: 0.9rem;
    }
    .btn {
      width: 100%;
      padding: 0.75rem;
      background: var(--primary);
      color: #fff;
      border: none;
      border-radius: 4px;
      font-size: 1rem;
      cursor: pointer;
      transition: background 0.2s;
    }
    .btn:hover {
      background: var(--primary-hover);
    }
    .footer {
      text-align: center;
      margin-top: 1rem;
      font-size: 0.9rem;
      color: #555;
    }
    @media (max-width: 360px) {
      .login-container {
        padding: 1.5rem;
      }
    }
  </style>
</head>
<body>
  <div class="login-container">
    <h2>Sign In</h2>
    <p class="intro">Fill in your credentials to access your account.</p>
    <?php if (!empty($login_err)): ?>
      <div class="alert-error">
        <?php echo htmlspecialchars($login_err) ?>
      </div>
    <?php endif; ?>
    <form
      action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>"
      method="post"
    >
      <div class="form-group">
        <label for="username">Username</label>
        <input
          type="text"
          id="username"
          name="username"
          value="<?php echo htmlspecialchars($username); ?>"
        >
        <span class="error">
          <?php echo htmlspecialchars($username_err); ?>
        </span>
      </div>
      <div class="form-group">
        <label for="password">Password</label>
        <input
          type="password"
          id="password"
          name="password"
        >
        <span class="error">
          <?php echo htmlspecialchars($password_err); ?>
        </span>
      </div>
      <div class="form-group">
        <button type="submit" class="btn">Login</button>
      </div>
      <div class="footer">
        Don't have an account? Please request access from admin.
      </div>
    </form>
  </div>
</body>
</html>