<?php
require_once 'php/auth_check.php'; // Ensure user is logged in
require_once 'php/db_connect.php';

// Fetch malls from the database
$malls = [];
$sql = "SELECT id, name, slug FROM malls ORDER BY name ASC";
if ($result = $conn->query($sql)) {
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $malls[] = $row;
        }
    }
    $result->free();
} else {
    // Handle error, e.g., log it or display a generic message
    $error_message = "Error fetching mall data: " . $conn->error;
}
$conn->close();

$pageTitle = "Select a Property";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Added for responsive behavior -->
    <title><?php echo htmlspecialchars($pageTitle); ?> - Mall Leasing</title>
    <link rel="stylesheet" href="css/style.css">
    <!-- Using Google Fonts for a more modern and professional look -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* CSS Variables for easy theme management */
        :root {
            --primary-color: #007bff; /* A standard blue for primary actions */
            --primary-hover-color: #0056b3; /* Darker blue on hover */
            --background-color: #f8f9fa; /* Light grey background */
            --card-background: #ffffff; /* White card background */
            --text-color: #343a40; /* Dark grey for general text */
            --heading-color: #212529; /* Even darker for headings */
            --border-color: #e9ecef; /* Light grey border */
            --shadow-color: rgba(0, 0, 0, 0.08); /* Subtle shadow */
            --link-color: #007bff; /* Blue for links */
            --link-hover-color: #0056b3; /* Darker blue for link hover */
            --error-color: #dc3545; /* Red for error messages */
            --error-bg-color: #f8d7da; /* Light red for error background */
            --error-border-color: #f5c6cb; /* Slightly darker red for error border */
        }

        body {
            font-family: 'Inter', sans-serif; /* Applied Inter font */
            margin: 0;
            padding: 20px; /* Add some padding around the edges */
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: var(--background-color);
            color: var(--text-color);
            line-height: 1.6;
            box-sizing: border-box; /* Ensures padding doesn't add to element's total width/height */
        }

        .mall-selection-container {
            background: var(--card-background);
            padding: 3rem 2.5rem; /* Increased padding for more breathing room */
            border-radius: 12px; /* More rounded corners */
            box-shadow: 0 10px 30px var(--shadow-color); /* Enhanced shadow for depth */
            text-align: center;
            width: 90%; /* Responsive width */
            max-width: 550px; /* Maximum width for larger screens */
            box-sizing: border-box;
            border: 1px solid var(--border-color); /* Subtle border */
        }

        .mall-selection-container h1 {
            margin-bottom: 2rem; /* More space below the heading */
            color: var(--heading-color);
            font-weight: 700; /* Bolder heading */
            font-size: 2.2em; /* Larger heading font size */
        }

        .user-greeting {
            margin-bottom: 2.5rem; /* More space below greeting */
            font-size: 1.2em; /* Slightly larger text */
            color: #555;
            font-weight: 400;
        }

        .mall-button {
            display: block;
            width: calc(100% - 20px); /* Adjust for horizontal padding, ensures full width minus margin */
            padding: 1.2rem 1.5rem; /* More vertical padding */
            margin: 1rem auto; /* Center buttons and add consistent vertical spacing */
            background-color: var(--primary-color);
            color: white;
            text-decoration: none;
            border-radius: 8px; /* Consistent rounded corners */
            font-size: 1.15em; /* Slightly larger font */
            font-weight: 600; /* Bolder text for buttons */
            transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.3s ease; /* Smooth transitions */
            box-shadow: 0 4px 12px rgba(0,0,0,0.1); /* Initial button shadow */
            border: none; /* Remove default border */
            cursor: pointer; /* Indicate clickable element */
            outline: none; /* Remove outline on focus for a cleaner look */
        }

        .mall-button:hover {
            background-color: var(--primary-hover-color);
            transform: translateY(-3px); /* Lift button on hover */
            box-shadow: 0 8px 20px rgba(0,0,0,0.15); /* Enhanced shadow on hover */
        }

        .mall-button:active {
            transform: translateY(0); /* Press down effect */
            box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Reduced shadow on click */
        }

        /* New styles for the footer links container */
        .footer-links {
            display: flex;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 1.5rem; /* Consistent space between links */
            margin-top: 2.5rem;
        }

        /* Unified style for all footer links */
        .footer-link {
            color: var(--link-color);
            text-decoration: none;
            font-weight: 500;
            font-size: 1em;
            transition: color 0.3s ease, text-decoration 0.3s ease;
        }

        .footer-link:hover {
            color: var(--link-hover-color);
            text-decoration: underline;
        }

        /* Original styles for mall-button are still needed */
        .mall-button {
            display: block;
            width: calc(100% - 20px);
            padding: 1.2rem 1.5rem;
            margin: 1rem auto;
            background-color: var(--primary-color);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-size: 1.15em;
            font-weight: 600;
            transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.3s ease;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            border: none;
            cursor: pointer;
            outline: none;
        }

        /* --- Make sure you remove the old .admin-link, .logout-link styles --- */

        @media (max-width: 480px) {
            /* ... other responsive styles ... */

            /* This makes the footer links stack on very small screens */
            .footer-links {
                flex-direction: column;
                gap: 1rem;
            }
        }

        .admin-link:hover, .logout-link:hover {
            color: var(--link-hover-color);
            text-decoration: underline; /* Underline on hover */
        }

        /* Styling for the error message */
        p[style="color: red;"] {
            color: var(--error-color) !important; /* Override inline style with a more robust red */
            background-color: var(--error-bg-color);
            border: 1px solid var(--error-border-color);
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 2rem; /* More space for the error message */
            font-size: 0.95em;
            font-weight: 500;
        }

        /* Responsive adjustments using Media Queries */
        @media (max-width: 768px) {
            .mall-selection-container {
                padding: 2.5rem 1.5rem;
                width: 95%;
            }

            .mall-selection-container h1 {
                font-size: 1.8em;
                margin-bottom: 1.8rem;
            }

            .user-greeting {
                font-size: 1.1em;
                margin-bottom: 2rem;
            }

            .mall-button {
                padding: 1em;
                font-size: 1.05em;
                width: calc(100% - 10px); /* Adjust for smaller screens */
            }

            .admin-link, .logout-link {
                margin-top: 2rem;
                margin-right: 0.8rem;
                margin-left: 0.8rem;
                font-size: 0.9em;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 15px;
            }

            .mall-selection-container {
                padding: 2rem 1rem;
                border-radius: 10px;
            }

            .mall-selection-container h1 {
                font-size: 1.6em;
                margin-bottom: 1.5rem;
            }

            .user-greeting {
                font-size: 1em;
                margin-bottom: 1.5rem;
            }

            .mall-button {
                padding: 0.9em;
                font-size: 1em;
                margin: 0.8rem auto;
            }

            .admin-link, .logout-link {
                display: block; /* Stack links on very small screens */
                margin: 1rem auto 0.5rem auto; /* Center and stack */
                font-size: 0.95em;
                width: fit-content; /* Make them only as wide as their content */
            }
        }
    </style>
</head>
<body>
    <div class="mall-selection-container">
        <h1><?php echo htmlspecialchars($pageTitle); ?></h1>
        <p class="user-greeting">Welcome, <?php echo htmlspecialchars($_SESSION["username"]); ?>!</p>

        <?php if (isset($error_message)): ?>
            <p style="color: red;"><?php echo htmlspecialchars($error_message); ?></p>
        <?php endif; ?>

        <?php if (!empty($malls)): ?>
            <?php foreach ($malls as $mall): ?>
                <a href="index.php?mall=<?php echo htmlspecialchars($mall['slug']); ?>" class="mall-button">
                    <?php echo htmlspecialchars($mall['name']); ?>
                </a>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No malls available at the moment.</p>
        <?php endif; ?>

        <div class="footer-links">
            <?php if (isset($_SESSION["is_admin"]) && $_SESSION["is_admin"] === true): ?>
                <a href="admin.php" class="footer-link">Admin Panel</a>
            <?php endif; ?>
            <a href="sales_kit.php" class="footer-link">Sales Kit</a>
            <a href="php/logout.php" class="footer-link">Logout</a>
        </div>
    </div>
</body>
</html>
